﻿// this lapp expects LeadId to be passed in body
// fetches the Lead details using V2 API 
// capitalizes first character of First and Last Name and returns
function main(queryString, body, callback) {

    try {
        let leadId = body.LeadId;
        getLeadById(leadId, function(error, data) {
            if (error) {
                callback(error, null);
            } else {
                let datatoReturn = {
                    FirstName: upperCaseWordsInString(data.FirstName),
                    LastName: upperCaseWordsInString(data.LastName),
                };
                callback(datatoReturn, null);
            }
        });
    } catch (e) {
        callback(e, null)
    }


}
/**
 *Uppercase the letter in each word of the  inputString
 */
function upperCaseWordsInString(inputString) {
    try {
        if (!inputString) {
            return "";
        }
        inputString = inputString.trim();
        return inputString.replace(/\b(\w+)/g, function(m, p) {
            return p[0].toUpperCase() + p.substr(1).toLowerCase();
        });
    } catch (error) {
        throw new Error(error.message);
    }
}

function getLeadById(leadId, callback) {
    try {
        let apiBasePath = ls.SETTINGS.LS_API_BASE_URL;
        let resource = 'LeadManagement.svc/Leads.GetById';
        let apiPath = apiBasePath + resource;
        let options = {
            url: apiPath,
            qs: {
                accessKey: ls.SETTINGS.LS_ACCESS_KEY,
                secretKey: ls.SETTINGS.LS_SECRET_KEY,
                id: leadId
            },
            headers: {
                'content-type': 'application/json'
            },
            json: true
        };
        request.get(options, function(error, response, body) {
            ls.log.Info(options);
            if (error) {
                callback('error calling LeadSquared API', null);
            } else {
                if (response.statusCode === 200) {
                    let lead = body[0];
                    callback(null, lead);
                } else callback(null, response.body.ExceptionMessage);
            }
        });
    } catch (e) {
        callback(e, null)
    }
}